<?php

namespace Drupal\Tests\drush_extra\Functional\Drush\Commands\Node;

use Drupal\drush_extra\Drush\Commands\Node\AccessRebuildCommand;
use Drupal\Tests\BrowserTestBase;
use Drush\TestTraits\DrushTestTrait;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the Drush command for rebuilding node access permissions.
 */
#[CoversClass(AccessRebuildCommand::class)]
#[Group('drush_extra')]
class AccessRebuildCommandTest extends BrowserTestBase {

  use DrushTestTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'node',
    'drush_extra',
  ];

  /**
   * Tests the node access rebuild command.
   */
  public function testAccessRebuildCommand() {
    $this->drush('node:access:rebuild');
    $output = $this->getOutput();
    $this->assertStringContainsString('Done rebuilding permissions', $output);
  }

}
