<?php

namespace Drupal\drw\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates that a date is within a configurable range.
 *
 * @Constraint(
 *   id = "DateRange",
 *   label = @Translation("Date Range", context = "Validation"),
 * )
 */
class DateRangeConstraint extends Constraint {

  /**
   * The minimum date (relative or absolute).
   *
   * @var string
   */
  public $minDate = '';

  /**
   * The maximum date (relative or absolute).
   *
   * @var string
   */
  public $maxDate = '';

  /**
   * The error message for dates before minimum.
   *
   * @var string
   */
  public $minErrorMessage = '';

  /**
   * The error message for dates before minimum.
   *
   * @var string
   */
  public $maxErrorMessage = '';

}
