# Date Range Widget (drw)
Drupal module for date range validation with relative date support and configurable constraints.

## Description
This module provides a date field widget with built-in date range validation (min/max). It allows configuring both absolute date restrictions (e.g., "2000-01-01") and relative ones (e.g., "today", "-18 years") with customizable error messages.

Important: The widget forces date-only mode — the time component is not used. When applied to `datetime` fields, the time portion will be ignored and normalized to midnight (00:00:00) for comparison and validation. This module therefore operates on dates only (no time validation).

## Features
- **Date range widget**: Extends Drupal's `DateTimeWidgetBase` but forces date-only mode (no time). The widget ignores the time component and only validates the date portion.
- **Relative dates**: Support for relative formats like "today", "-18 years", "+1 month"
- **Absolute dates**: Support for standard date formats (YYYY-MM-DD)
- **Server-side validation**: Symfony validation constraint for backend validation
- **HTML5 validation**: Automatic `min` and `max` attributes on form fields (date inputs)
- **Customizable messages**: Configure error messages for min/max limits and required field validation
- **Required field validation**: Custom error message for empty required fields
- **Automatic application**: Constraints are automatically applied via `hook_entity_bundle_field_info_alter`

## Configuration
### Widget Configuration
1. Navigate to the form display configuration for your content type or entity
2. Select a field of type datetime
3. Choose the **"Date with range validation"** widget
4. Click the gear icon to configure settings:

#### Available Settings
- **Minimum date**: Minimum allowed date
  - Examples: `today`, `-18 years`, `2000-01-01`, `-2 weeks`
  - Leave empty for no minimum limit

- **Maximum date**: Maximum allowed date
  - Examples: `today`, `+1 year`, `2025-12-31`, `+3 months`
  - Leave empty for no maximum limit

- **Minimum date error message**: Error message when date is before minimum
  - Use `@min` as placeholder for the minimum date
  - Leave empty to use default message: "The date must be on or after @min."

- **Maximum date error message**: Error message when date is after maximum
  - Use `@max` as placeholder for the maximum date
  - Leave empty to use default message: "The date must be on or before @max."

- **Required field error message**: Custom error message when field is required but empty
  - Leave empty to use Drupal's default required field message
  - This message is displayed when a required date field is submitted without a value

### Configuration Examples
#### Minimum Age Validation (18 years)
```
Minimum date: -18 years
Maximum date: (empty)
Min error message: You must be at least 18 years old (born before @min).
```

#### Specific Date Range
```
Minimum date: 2024-01-01
Maximum date: 2024-12-31
Min error message: The date must be in 2024 (after @min).
Max error message: The date must be in 2024 (before @max).
```

#### Future Dates Only
```
Minimum date: today
Maximum date: +5 years
Min error message: The date cannot be in the past.
Max error message: The date cannot be more than 5 years in the future.
```

#### Required Field with Custom Message
```
Minimum date: (empty)
Maximum date: (empty)
Required error message: Please select a date for your appointment.
```
Note: The field must be configured as required in the field settings for the required error message to be used.

### Validation Flow
1. User configures the widget via the administration interface
2. Parameters are stored in the form display configuration
3. When the form loads:
   - Widget adds HTML5 min/max attributes for client-side validation
   - Widget adds custom required error message if configured
   - Hook applies validation constraints to the field (DateRange and NotBlank if required)
4. On form submission:
   - HTML5 validation (if supported by browser)
   - Server validation via `DateRangeConstraintValidator` for min/max dates
   - Server validation via `NotBlank` constraint for required fields with custom message
   - Display of custom error messages if violation occurs

## Supported Date Formats
All supported formats are parsed, but only the date portion is used for validation and comparison; any time component is discarded and normalized to midnight.

### Relative Dates
- `today`: Today (date only)
- `now`: Now — the date part will be used and the time part ignored
- `-X days/weeks/months/years`: In the past
- `+X days/weeks/months/years`: In the future
- `first day of` / `last day of`: Start/end of period

### Absolute Dates
- ISO 8601: `2024-01-31`
- Textual format: `31 January 2024`
- Unix timestamp: `1706659200`

Important: The widget forces display in "date only" mode (no time picker) and validation is performed only on the date part.

## Dependencies
- Drupal Core >= 10.x
