<?php

namespace Drupal\drw;

use Drupal\Core\Datetime\DrupalDateTime;

/**
 * Trait for parsing relative date formats.
 */
trait DateParserTrait {

  /**
   * Parse relative date formats.
   *
   * @param string $date_string
   *   The date string to parse.
   *
   * @return \Drupal\Core\Datetime\DrupalDateTime|null
   *   The parsed date object or NULL on error.
   */
  protected function parseRelativeDate(string $date_string): ?DrupalDateTime {
    if (empty($date_string)) {
      return NULL;
    }

    $date = new DrupalDateTime($date_string);

    if ($date->hasErrors()) {
      return NULL;
    }

    return $date;
  }

}
