# Date Range Widget (drw)
Drupal module for date range validation with relative date support and customizable error messages.

## Features
- **Date-only validation**: Forces date-only mode (no time component)
- **Relative dates**: Support for formats like "today", "-18 years", "+1 month"
- **Absolute dates**: Standard date formats (YYYY-MM-DD)
- **HTML5 validation**: Automatic `min` and `max` attributes
- **Custom error messages**: Optional server-side validation with personalized messages

## Quick Start
1. Add a datetime field to your content type
2. In form display settings, select **"Date with range validation"** widget
3. Configure min/max dates and optionally enable custom error messages

## Configuration

### Basic Settings
- **Minimum date**: `today`, `-18 years`, `2000-01-01`, etc. (empty = no limit)
- **Maximum date**: `today`, `+1 year`, `2025-12-31`, etc. (empty = no limit)

### Custom Error Messages (Optional)
Check **"Enable custom error messages"** to:
- Define custom error text for min/max violations
- Set custom required field message
- Use placeholders: `@min` for minimum date, `@max` for maximum date

**Note**: Enabling this disables HTML5 validation for the entire form, relying on server-side validation instead.

---

開発者：Rémi SIMAER  

Drupal開発者を探している採用担当者の方は、ぜひご連絡ください：

LinkedIn : https://www.linkedin.com/in/remisimaer/

履歴書 : https://remisimaer.com/cv_remi_simaer.pdf

Drupal : https://www.drupal.org/u/remi-simaer
