# DSFR - Card component

Here are integration examples of use :

## PHP example integration

```php
$cardsRenderArray['card'] = [
  '#prefix' => '<div class="fr-container">
<div class="fr-grid-row fr-grid-row--gutters">',
  '#suffix' => '</div></div>',
];
foreach([TRUE, FALSE] as $b) {
  $cardsRenderArray['card'][] = [
    '#prefix' => '<div class="fr-col-md-6">',
    '#suffix' => '</div>',
    '#type' => 'component',
    '#component' => 'dsfr:card',
    '#props' => [
      'title' => t('Card title'),
      'href' => '/',
      'download' => $b,
      'detail_start' => t('Detail start'),
      'detail_end' => t('Detail end'),
    ],
    '#slots' => [
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'span',
        '#value' => t('I am a render array in a slot.'),
      ],
      'header_image' => [
        '#markup' => '<img
        src="https://www.systeme-de-design.gouv.fr
 /v1.14/storybook/img/placeholder.16x9.png"
 class="fr-responsive-img" alt="to replace">',
      ]
    ],
  ];
  if ($b) {
    $cardsRenderArray['card'][0]['#slots']['link'] = [
      '#type' => 'link',
      '#url' => Url::fromRoute('<front>'),
      '#title' => t('Card title that use a link'),
    ];
  }

}
```
