# DSFR - FranceConnect component

Here are integration examples of use :

## PHP integration

Following example with link/button :

```php
foreach([TRUE, FALSE] as $plus) {
  $element['franceconnect'][] = [
    '#type' => 'component',
    '#component' => 'dsfr:franceconnect',
    '#props' => [
      'label' => $plus ? t('With plus') : t('Without plus'),
      'html_tag' => $plus ? 'a' : 'button',
      'button_attributes' => $plus ?
        new Attribute([
            'href' => Url::fromRoute('<front>')->toString()
            ])
        : NULL,
      'brand' => $plus ? 'FranceConnectPlus' : 'FranceConnect',
    ],
    '#slots' => [
      'link' => [
        '#type' => 'link',
        '#title' => t('How to connect ?'),
        '#url' => Url::fromRoute('<front>'),
      ]
    ],
  ];
}
```
