# DSFR - Card component

Here are integration examples of use :

## PHP example integration

```php
$tooltipRenderArray= [
  'button' => [
    '#type' => 'button',
    '#value' => $this->t('Tooltip button'),
    '#attributes' => [
      'aria-describedby' => 'my-tooltip',
      'class' => ['fr-btn', 'fr-btn--tooltip'],
    ],
  ],
  'link' => [
    '#type' => 'link',
    '#title' => $this->t('Tooltip link'),
    '#url' => Url::fromRoute('<front>'),
    '#attributes' => [
      'aria-describedby' => 'my-tooltip',
      'class' => ['fr-link--tooltip'],
    ],
  ],
  'tooltip' => [
    '#type' => 'component',
    '#component' => 'dsfr:tooltip',
    '#props' => [
      'html_id' => 'my-tooltip',
    ],
    '#slots' => [
      'description' => ['#markup' => '<p>Very nice <i>tooltip</i></p>'],
    ],
  ],
];
```
