/**
 * @file
 * Manage accordion features with DSFR.
 */

((Drupal, once) => {
  "use strict";

  Drupal.behaviors.dsfrAccordion = {
    attach: (context) => {

      // Search all accordion in current context.
      once("dsfr-accordion", ".fr-accordion", context).forEach((element) => {
        // Manage accordion button click event.
        element.querySelector(".fr-accordion__btn").addEventListener("click", event => {
          // Disable form submission.
          event.preventDefault();
        });
      });
    }
  };

})(Drupal, once);
