/**
 * @file
 * Manage horizontal tabs features with DSFR.
 */

((Drupal, once) => {
  "use strict";

  const CLASS_LIST = "fr-tabs__list";
  const CLASS_TAB = "fr-tabs__tab";
  const CLASS_TAB_SELECTED = "fr-tabs__tab--selected";
  const CLASS_TABS = "fr-tabs";

  Drupal.behaviors.dsfrHorizontalTabs = {
    attach: (context) => {

      // Search all horizontal tabs in current context.
      once("dsfr-horizontal-tabs", ".horizontal-tabs", context).forEach((element) => {
        const wrapper = element.querySelector(`.${CLASS_TABS}`);
        const list = element.querySelector(`.horizontal-tabs-list.${CLASS_LIST}`);
        if (!wrapper || !list) {
          return;
        }

        wrapper.append(list);

        list.querySelectorAll("li").forEach((item) => {
          const link = item.querySelector("a");
          link.classList.add(CLASS_TAB);

          if (item.classList.contains("selected")) {
            link.classList.add(CLASS_TAB_SELECTED);
            link.setAttribute("aria-selected", "true");
          }

          link.addEventListener("click", () => {
            // Remove selected class on old active link.
            const selected = list.querySelector(`.${CLASS_TAB_SELECTED}`);
            selected.classList.remove(CLASS_TAB_SELECTED);
            selected.removeAttribute("aria-selected");

            // Add class to new element.
            link.classList.add(CLASS_TAB_SELECTED);
            link.setAttribute("aria-selected", "true");
          })
        });
      });
    }
  };

})(Drupal, once);
