/**
 * @file
 * Manage paragraphs widget rendering with DSFR styles.
 */

(function (Drupal, once) {
  "use strict";

  const CLASS_LIST = "fr-tabs__list";
  const CLASS_TAB = "fr-tabs__tab";
  const CLASS_TAB_SELECTED = "fr-tabs__tab--selected";
  const CLASS_TABS = "fr-tabs";

  Drupal.behaviors.dsfrParagraphsWidget = {
    attach: (context) => {
      const wrappers = once("dsfr-paragraphs-tabs-wrapper", ".paragraphs-tabs-wrapper", context);
      if (!wrappers) {
        return;
      }

      wrappers.forEach(wrapper => {
        const list = wrapper.querySelector(".paragraphs-tabs");
        if (
          !list ||
          list.classList.contains("paragraphs-tabs-hide")
        ) {
          return;
        }

        const listWrapper = document.createElement("div");
        listWrapper.classList.add(CLASS_TABS);
        wrapper.prepend(listWrapper);

        listWrapper.appendChild(list);
        list.classList.add(CLASS_LIST);

        list.querySelectorAll("li > a").forEach(link => {
          link.classList.add(CLASS_TAB);

          if (link.classList.contains("is-active")) {
            link.classList.add(CLASS_TAB_SELECTED);
            link.setAttribute("aria-selected", "true");
          }

          link.addEventListener("click", () => {
            // Remove selected class on old active link.
            const selected = list.querySelector(`.${CLASS_TAB_SELECTED}`);
            selected.classList.remove(CLASS_TAB_SELECTED);
            selected.removeAttribute("aria-selected");

            // Add class to new element.
            link.classList.add(CLASS_TAB_SELECTED);
            link.setAttribute("aria-selected", "true");
          })
        });
      });
    },
  };

})(Drupal, once);
