/**
 * @file
 * Manage media library view behaviors.
 */

((Drupal, once) => {
  "use strict";


  Drupal.behaviors.dsfrMediaLibraryView = {
    attach: (context) => {
      const selectAll =  once("dsfr-media-library-select-all", ".media-library-select-all", context);
      if (!selectAll.length) {
        return;
      }

      selectAll.forEach(element => {
        // Move "select all" element after header.
        context.querySelector("#edit-header").after(element);
      });
    },
  };

})(Drupal, once);
