/**
 * Override some "Tarte au citron" behaviors.
 */

((document, tarteaucitron) => {

  const loadOriginal = tarteaucitron.events.load;

  /**
   * Extends "Tarte au citron" load function.
   */
  tarteaucitron.events.load = () => {
    loadOriginal.call();

    // Delete image to benefits of text.
    const iconManager = document.querySelector("#tarteaucitronIcon #tarteaucitronManager");
    if (iconManager) {
      iconManager.innerText = Drupal.t("Cookies");
    }

    // Replace "X" with translated "Close" text.
    const closeCrossButton = document.querySelector("#tarteaucitronRoot #tarteaucitronCloseCross");
    if (closeCrossButton) {
      closeCrossButton.innerText = Drupal.t("Close");
    }

    // Replace "Tarte au citron" credits logo with a translatable text.
    const credits = document.querySelector("#tarteaucitronRoot .tarteaucitronSelfLink");
    if (credits) {
      credits.innerText = Drupal.t("Official website of Tarte au citron");
      credits.setAttribute("title",
        Drupal.t("Official website of Tarte au citron - new window")
      );
    }
  }

})(document, tarteaucitron);
