/**
 * @file
 * Manage allowed colors selection behaviors.
 */

((Drupal, once) => {

  /**
   * Add "Check all" and "Uncheck all" buttons.
   *
   * @param {Element} group
   *   The allowed colors group.
   */
  const addCheckButtons = (group) => {
    const listCheck = document.createElement("ul");
    listCheck.classList.add("dsfr4drupal-colors-allowed-colors-group__list-check");
    group.querySelector("input[type='checkbox']:first-child").before(listCheck);

    const listCheckItem = document.createElement("li");
    listCheck.append(listCheckItem);

    // Add a "Check all" button.
    const checkkAll = document.createElement("button");
    checkkAll.setAttribute("type", "button");
    checkkAll.classList.add("button", "button--secondary");
    checkkAll.innerHTML = Drupal.t("Check all");
    listCheckItem.append(checkkAll);

    checkkAll.addEventListener("click", (event) => {
      event.preventDefault();

      group.querySelectorAll("input[type='checkbox']").forEach((checkbox) => {
        checkbox.checked = true;
      });
    });

    const listCheckItem2 = document.createElement("li");
    listCheck.append(listCheckItem2);

    // Add an "Uncheck all" button.
    const uncheckkAll = document.createElement("button");
    checkkAll.setAttribute("type", "button");
    uncheckkAll.classList.add("button", "button--secondary");
    uncheckkAll.innerHTML = Drupal.t("Uncheck all");
    listCheckItem2.append(uncheckkAll);

    uncheckkAll.addEventListener("click", (event) => {
      event.preventDefault();

      group.querySelectorAll("input[type='checkbox']").forEach((checkbox) => {
        checkbox.checked = false;
      });
    });
  }

  Drupal.behaviors.dsfr4drupalColorsAllowedColorsSelect = {
    attach: (context) => {
      const groups = once("dsfr4drupal-colors-allowed-colors-group", ".dsfr4drupal-colors-allowed-colors-group", context);

      groups.forEach((group) => {
        addCheckButtons(group);
      });
    }
  }
})(Drupal, once);
