<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_colors\Plugin\Field\FieldFormatter;

use Drupal\dsfr4drupal_colors\Helper\ColorsHelperInterface;
use Drupal\dsfr4drupal_colors\Plugin\Field\FieldType\ColorFieldType;
use Drupal\Core\Field\FormatterBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for dsfr4drupal_color formatters.
 */
abstract class ColorFieldFormatterBase extends FormatterBase {

  /**
   * The colors' helper.
   *
   * @var \Drupal\dsfr4drupal_colors\Helper\ColorsHelperInterface
   */
  protected ColorsHelperInterface $helper;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create(
      $container,
      $configuration,
      $plugin_id,
      $plugin_definition,
    );
    $instance->helper = $container->get('dsfr4drupal_colors.helper.colors');

    return $instance;
  }

  /**
   * View an individual field raw value.
   *
   * @param \Drupal\dsfr4drupal_colors\Plugin\Field\FieldType\ColorFieldType $item
   *   The field item.
   *
   * @return string
   *   The color CSS variable name.
   */
  protected function viewRawValue(ColorFieldType $item): string {
    return $item->color;
  }

  /**
   * View an individual field value.
   *
   * @param \Drupal\dsfr4drupal_colors\Plugin\Field\FieldType\ColorFieldType $item
   *   The field item.
   *
   * @return string
   *   The color CSS declaration.
   */
  protected function viewValue(ColorFieldType $item): string {
    return $this->helper->getColorCssVariable($item->color);
  }

}
