<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_colors\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides the site configuration form.
 *
 * @internal
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'dsfr4drupal_colors_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['dsfr4drupal_colors.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config($this->getEditableConfigNames()[0]);

    $form['scheme'] = [
      '#type' => 'radios',
      '#title' => $this->t('Color palette'),
      '#options' => [
        'light' => $this->t('Light theme'),
        'dark' => $this->t('Dark theme'),
      ],
      '#description' => $this->t(
        'By default, colors in forms are displayed in a light theme. You can force the use of dark colors if you wish. <a href=":url" lang="fr">More informations</a>.',
        [':url' => 'https://www.systeme-de-design.gouv.fr/fondamentaux/couleurs-palette/']
      ),
      '#config_target' => $this->getEditableConfigNames()[0] . ':scheme',
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

}
