<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_colors\Helper;

/**
 * Provides a ColorsHelper interface.
 */
interface ColorsHelperInterface {

  const COLOR_ORDER = [
    // Keep the same order.
    'blue',
    'red',
    'green',
    'purple',
    'orange',
    'pink',
    'yellow',
    'brown',
    'beige',
    // Move grey to the end.
    'grey',
    // Move system colors to the end.
    'info',
    'success',
    'warning',
    'error',
    ];

  /**
   * Define a class to force light/dark theme colors usage.
   *
   * @var string
   */
  const CLASS_THEME_DARK = 'dsfr4drupal-colors-theme-dark';
  const CLASS_THEME_LIGHT = 'dsfr4drupal-colors-theme-light';

  /**
   * The DSFR library path.
   *
   * @var string
   */
  const LIBRARY_PATH = 'libraries/dsfr/dist/';

  /**
   * Generate CSS file with DSFR colors declaration.
   */
  public function generateCssColorsFile(): void;

  /**
   * Get color as a CSS value.
   *
   * @param string $color
   *   The color value.
   *
   * @return string
   *   The CSS value.
   */
  public function getColorCssValue(string $color): string;

  /**
   * Get color as a CSS variable.
   *
   * @param string $color
   *   The color value.
   *
   * @return string
   *   The CSS variable.
   */
  public function getColorCssVariable(string $color): string;

  /**
   * Get colors available.
   *
   * @return array
   *   The available colors.
   */
  public function getColorsAvailable(): array;

  /**
   * Get selectable colors options.
   *
   * @return array
   *   The selectable colors options.
   */
  public function getColorsOptions(): array;

  /**
   * Get selectable colors options by groups.
   *
   * @return array
   */
  public function getColorsOptionsByGroups(): array;

  /**
   * Get DSFR CSS core path.
   *
   * @return string
   *   The DSFR core path.
   */
  public function getCssCorePath(): string;

  /**
   * Get DSFR CSS scheme path.
   *
   * @return string
   *   The DSFR scheme path.
   */
  public function getCssSchemePath(): string;

  /**
   * Get colors groups.
   *
   * @return array
   *   THe colors groups.
   */
  public function getGroups(): array;

}
