<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_colors\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the dsfr4drupal_color field text formatter.
 */
#[FieldFormatter(
  id: 'dsfr4drupal_color_field_formatter_text',
  label: new TranslatableMarkup('Color as text'),
  field_types: [
    'dsfr4drupal_color_field_type',
  ],
)]
class ColorFieldFormatterText extends ColorFieldFormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $this->viewRawValue($item)];
    }

    return $elements;
  }

}
