<?php

/**
 * @file
 * DSFR for Drupal - Picker API documentation.
 */

declare(strict_types=1);

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Add custom icons into DSFR icon picker.
 *
 * @return array
 *   Custom icons to add into icon picker.
 */
function hook_dsfr4drupal_picker_icons(): array {
  // Create a new group "custom" with 2 icons.
  return [
    'custom' => [
      'fr-icon-custom-fill',
      'fr-icon-custom-line',
    ],
  ];
}

/**
 * Alter available DSFR icons.
 *
 * @param array $icons
 *    The available DSFR icons.
 */
function hook_dsfr4drupal_picker_icons_alter(array &$icons): void {
  // Remove existing icon "circle".
  $key = array_search('fr-icon-add-circle-fill', $icons);
  if ($key !== FALSE) {
    unset($icons['system'][$key]);
  }
  $key = array_search('fr-icon-add-circle-line', $icons);
  if ($key !== FALSE) {
    unset($icons['system'][$key]);
  }
}

/**
 * Add custom pictograms into DSFR pictogram picker.
 *
 * @return array
 *   Custom pictograms to add into pictogram picker.
 */
function hook_dsfr4drupal_picker_pictograms(): array {
  // Create a new group "custom" with 2 pictograms.
  // If yours pictograms are not available in DSFR library, you need to implement
  // the "dsfr4drupal_picker_pictogram_path" hook alter to override
  // pictogram path with the good path.
  return [
    'custom' => [
      'custom/pictogram1',
      'custom/pictogram2',
    ],
  ];
}

/**
 * Alter available DSFR pictograms.
 *
 * @param array $pictograms
 *   The available DSFR pictograms.
 */
function hook_dsfr4drupal_picker_pictograms_alter(array &$pictograms): void {
  // Remove existing pictogram "factory".
  $key = array_search('buildings/factory', $pictograms['buildings']);
  if ($key !== FALSE) {
    unset($pictograms['buildings'][$key]);
  }
}

/**
 * Alter DSFR pictogram.
 * It's probably needed for custom pictograms.
 */
function hook_dsfr4drupal_picker_pictogram_path_alter(string $pictogram, string &$path): void {
  [$group, $pictogram] = explode('/', $pictogram);

  if ($group === 'custom') {
    $path = 'my-custom-path/' . $pictogram . '.svg';
  }
}

/**
 * @} End of "addtogroup hooks".
 */
