/**
 * @file
 * DSFR for Drupal - Iconpicker behavior.
 */

(($, Drupal, once) => {
  Drupal.behaviors.dsfr4DrupalIconpicker = {
    attach(context, settings) {
      $(once("jsDsfr4DrupalIconpicker", "select.dsfr4drupal-picker-icon-element", context)).each((index, element) => {
        const $element = $(element);

        const emptyIcon = !!$element.attr(`${settings.dsfr4drupal_picker.data_attribute_prefix}empty-icon`);
        const hasSearch = !!$element.attr(`${settings.dsfr4drupal_picker.data_attribute_prefix}has-search`);
        const keepOpen = !!$element.attr(`${settings.dsfr4drupal_picker.data_attribute_prefix}keep-open`);

        // Keep widget open instead of display dropdown.
        // The "FontIconPicker" plugin doesn't provide an option to manage this mode of operation.
        // Diy with the native behaviors to allow this.
        if (keepOpen) {
          $element.parent().addClass("dsfr4drupal-picker-keep-open");
        }

        // Initialize icon picker.
        $element.fontIconPicker({
          allCategoryText: Drupal.t("From all categories"),
          autoClose: !keepOpen,
          emptyIcon: emptyIcon && !keepOpen,
          hasSearch: hasSearch,
          iconGenerator: function (icon) {
            return "<span class=\"" + icon  + "\" aria-hidden=\"true\"></span>";
          },
          searchPlaceholder: Drupal.t("Search icons"),
          source: settings.dsfr4drupal_picker.source_icon,
          theme: `fip-${settings.dsfr4drupal_picker.theme.replace("-", "")}`,
          unCategorizedText: Drupal.t("Uncategorized"),
        });
      });
    }
  };
})(jQuery, Drupal, once);
