<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Element;

use Drupal\Core\Render\Attribute\FormElement;

/**
 * Provides a pictogram picker form element.
 *
 * Usage example:
 *
 * @code
 * $form['pictogram'] = [
 *   '#type' => 'dsfr4drupal_picker_pictogram',
 *   '#title' => $this->t('Pictogram'),
 *   '#default_value' => 'system/warning',
 *   '#allowed_groups' => ['system'],
 *   '#has_search' => FALSE,
 *   '#keep_open' => TRUE,
 * ];
 * @endcode
 *
 */
#[FormElement('dsfr4drupal_picker_pictogram')]
class PictogramPicker extends PickerBase {

  /**
   * {@inheritdoc}
   */
  const PICKER_ELEMENT = 'pictogram';

  /**
   * {@inheritdoc}
   */
  public static function preRenderPicker(array $element): array {
    $element = parent::preRenderPicker($element);

    /** @var \Drupal\dsfr4drupal_picker\Plugin\Dsfr4DrupalPicker\PictogramPickerInterface $picker */
    $picker = \Drupal::service('plugin.manager.dsfr4drupal_picker')->createInstance(static::PICKER_ELEMENT);

    $pictograms_path = [];
    foreach ($picker->getItemsAvailable() as $pictograms) {
      foreach ($pictograms as $pictogram) {
        $pictograms_path[$pictogram] = base_path() . $picker->getItemPath($pictogram);
      }
    }

    $element['#attached']['drupalSettings']['dsfr4drupal_picker']['pictograms_path'] = $pictograms_path;

    return $element;
  }

}
