<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Form;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\CloseModalDialogCommand;
use Drupal\Core\Form\FormStateInterface;
use Drupal\editor\Ajax\EditorDialogSave;
use Drupal\filter\FilterFormatInterface;

/**
 * Ckeditor dialog form to insert DSRR icon.
 */
class IconDialogForm extends DialogFormBase {

  /**
   * {@inheritdoc}
   */
  const PICKER_ELEMENT = 'icon';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dsfr4drupal_picker_icon_dialog_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(
    array $form,
    FormStateInterface $form_state,
    ?FilterFormatInterface $filter_format = NULL
  ): array {
    $form = parent::buildForm($form, $form_state, $filter_format);

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function ajaxSubmitForm(array &$form, FormStateInterface $form_state) : AjaxResponse {
    $response = parent::ajaxSubmitForm($form, $form_state);

    $response->addCommand(
      new EditorDialogSave(
        [
          'element' => 'dsfrIcon',
          'attributes' => [
            'data-icon' => $form_state->getValue('element'),
            'data-size' => 'md',
          ],
        ],
      )
    );
    $response->addCommand(new CloseModalDialogCommand(FALSE));

    return $response;
  }

}
