<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Picker plugin interface.
 *
 * @package Drupal\dsfr4drupal_picker
 */
interface PickerInterface {

  /**
   * The DSFR library path.
   *
   * @var string
   */
  const LIBRARY_PATH = 'libraries/dsfr/dist/';

  /**
   * Get group label.
   *
   * @param string $group
   *   The group machine name.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The group label.
   */
  public function getGroupLabel(string $group): TranslatableMarkup;

  /**
   * Get items' groups available.
   *
   * @return string[]
   *   The items' groups available.
   */
  public function getGroups(): array;

  /**
   * Get filepath from given item.
   *
   * @param string $item
   *   The item to load.
   *
   * @return string
   *   The item's path.
   */
  public function getItemPath(string $item): string;

  /**
   * Get items available.
   *
   * @return string[]
   *   The items available.
   */
  public function getItemsAvailable(): array;

  /**
   * Get items available in DSFR library.
   *
   * @return string[]
   *   The items available.
   */
  public function getItemsOriginal(): array;

  /**
   * Get items path.
   *
   * @return string
   *   The items path.
   */
  public function getItemsPath(): string;

  /**
   * Sort groups.
   *
   * @param array $groups
   *   The groups to sort.
   */
  public function sortGroups(array &$groups): void;

  /**
   * Sort groups by key.
   *
   * @param array $groups
   *   The groups to sort.
   */
  public function sortGroupsByKey(array &$groups): void;

}
