<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'dsfr4drupal_picker_icon' field type.
 */
#[FieldType(
  id: "dsfr4drupal_picker_icon",
  label: new TranslatableMarkup("DSFR for Drupal - Icon Picker"),
  default_widget: "dsfr4drupal_picker_icon",
  default_formatter: "dsfr4drupal_picker_icon",
)]
class IconPicker extends PickerBase {

  /**
   * The picker element.
   */
  const PICKER_ELEMENT = 'icon';

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition): array {
    $definitions = parent::propertyDefinitions($field_definition);

    $definitions['value']->setDescription(new TranslatableMarkup(
    'The value corresponds to the class of the icon.'
    ));

    return $definitions;
  }
}
