<?php

namespace Drupal\dsfr4drupal_picker\Plugin\Filter;

use Drupal\Component\Utility\Html;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\filter\Attribute\Filter;
use Drupal\filter\Plugin\FilterInterface;

/**
 * Provides a filter to embed DSFR icons using a custom tag.
 *
 * @internal
 */
#[Filter(
  id: "dsfr4drupal_picker_icon",
  title: new TranslatableMarkup("DSFR for Drupal - Picker"),
  description: new TranslatableMarkup("Embeds DSFR Icons using a custom tag, <code>&lt;dsfr-icon&gt;</code>."),
  type: FilterInterface::TYPE_TRANSFORM_REVERSIBLE,
  weight: 100,
)]
class IconPickerFilter extends PickerFilterBase {

  /**
   * {@inheritdoc}
   */
  const TAG_NAME = 'dsfr-icon';

  /**
   * {@inheritdoc}
   */
  const ITEM_ATTRIBUTE = 'data-icon';
  const SIZE_ATTRIBUTE = 'data-size';

  /**
   * {@inheritdoc}
   */
  protected function buildItem(\DOMElement $node): array {
    $icon = $node->getAttribute(static::ITEM_ATTRIBUTE);
    $size = $node->getAttribute(static::SIZE_ATTRIBUTE) ?: '';

    return [
      '#type' => 'component',
      '#component' => 'dsfr4drupal_picker:icon',
      '#props' => [
        'icon' => Html::escape($icon),
        'size' => Html::escape($size),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function tips($long = FALSE) {
    if ($long) {
      return $this->t('
      <p>You can embed DSFR icons:</p>
      <ul>
        <li>Choose which DSFR icon to embed: <code>&lt;dsfr-icon data-icon="fr-" /&gt;</code></li>
        <li>Optionally also choose a size: <code>data-size="lg"</code>, otherwise the default size is used.</li>
      </ul>');
    }
    else {
      return $this->t('You can embed DSFR icons (using the <code>&lt;dsfr-icon&gt;</code> tag).');
    }
  }

}
