/**
 * @file
 * Provides several commands used by Ckeditor5 DSFR picker plugins.
 */

import { Command } from "ckeditor5/src/core";
import { createIcon } from "./utils";

/**
 * @private
 */
export default class InsertIconCommand extends Command {
  execute (attributes, element) {
    const { model } = this.editor;
    const dsfrIconPickerEditing = this.editor.plugins.get(
      "DsfrIconPickerEditing",
    );

    const dataAttributeMapping = Object.fromEntries(
      Object.entries(dsfrIconPickerEditing.attrs).map(([key, value]) => [
        value,
        key,
      ]),
    );

    // \Drupal\dsfr4drupal_picker\Form\IconDialogForm returns data in keyed by
    // data-attributes used in view data. This converts data-attribute keys to
    // keys used in model.
    const modelAttributes = Object.fromEntries(
      Object.keys(dataAttributeMapping)
        .filter((attribute) => attributes[attribute])
        .map((attribute) => [
          dataAttributeMapping[attribute],
          attributes[attribute],
        ]),
    );

    model.change((writer) => {
      // Insert icon at the current selection position
      // in a way that will result in creating a valid model structure.
      model.insertContent(
        createIcon(writer, modelAttributes, element),
      );
    });
  }

}
