/**
 * @file
 * Initialize the DSFR Icon Picker plugin for CKEditor 5.
 */

import { Plugin } from "ckeditor5/src/core";
import DsfrIconPickerEditing from "./editing";
import DsfrIconPickerToolbar from "./toolbar";
import DsfrIconPickerUI from "./ui";

/**
 * @private
 */
export default class DsfrIconPicker extends Plugin {

  /**
   * {@inheritdoc}
   */
  static get requires() {
    return [DsfrIconPickerEditing, DsfrIconPickerUI, DsfrIconPickerToolbar];
  }

  /**
   * {@inheritdoc}
   */
  static get pluginName() {
    return "DsfrIconPicker";
  }

}
