/**
 * @file
 * Provides several commands used by Ckeditor5 DSFR picker plugins.
 */

import { Plugin } from "ckeditor5/src/core";
import DsfrIconPickerSizeCommand from "./command";

/**
 * Returns a converter that consumes the `href` attribute if a link contains a <drupal-media>.
 *
 * @return {Function}
 *   A function that adds an event listener to upcastDispatcher.
 */

/**
 * Model to view and view to model conversions for DSFR icon elements.
 *
 * @private
 */
export default class DsfrIconPickerSizeEditing extends Plugin {
  /**
   * {@inheritdoc}
   */
  static get requires() {
    return ["DsfrIconPickerSizeEditing"];
  }

  /**
   * {@inheritdoc}
   */
  static get pluginName() {
    return "DsfrIconPickerSizeEditing";
  }

  /**
   * {@inheritdoc}
   */
  init() {
    this.options = [
      {
        value: "xs",
        label: Drupal.t("Extra Small"),
      },
      {
        value: "sm",
        label: Drupal.t("Small"),
      },
      {
        value: "md",
        label: Drupal.t("Medium"),
      },
      {
        value: "lg",
        label: Drupal.t("Large"),
      },
    ];

    this.editor.commands.add(
      "sizeIcon",
      new DsfrIconPickerSizeCommand(this.editor, "dataSize"),
    );
  }

}
