/**
 * @file
 * Registers the DSFR Icon Picker Sizes to the CKEditor instance(s) and binds functionality to it.
 */

import { Plugin } from "ckeditor5/src/core";
import { ButtonView } from "ckeditor5/src/ui";

/**
 * The link media UI plugin.
 *
 * @private
 */
export default class DsfrIconPickerSizeUI extends Plugin {

  /**
   * {@inheritdoc}
   */
  static get requires() {
    return ["DsfrIconPickerEditing"];
  }

  /**
   * {@inheritdoc}
   */
  static get pluginName() {
    return "DsfrIconPickerSizeUI";
  }

  /**
   * {@inheritdoc}
   */
  init() {
    this._createToolbarSizeButtons();
  }

  /**
   * Creates a `DsfrIconPickerSizeUI` button view.
   *
   * Clicking these buttons set icon size.
   */
  _createToolbarSizeButtons() {
    const {editor} = this;

    const dsfrIconPickerSizeEditing = this.editor.plugins.get(
      "DsfrIconPickerSizeEditing",
    );

    const sizeCommand = editor.commands.get("sizeIcon");

    dsfrIconPickerSizeEditing.options.forEach((option) => {
      editor.ui.componentFactory.add(`dsfrIconPickerSize__${option.value}`, (locale) => {
        const buttonView = new ButtonView(locale);

        buttonView.set({
          isEnabled: true,
          label: option.value.toUpperCase(),
          withText: true,
          tooltip: option.label,
        });

        // Bind button to the command.
        buttonView.bind("isEnabled").to(sizeCommand);
        buttonView.bind("isOn").to(sizeCommand, "value", value => value === option.value);

        // Execute command.
        this.listenTo(buttonView, "execute", () => {
          editor.execute( "sizeIcon", { value: option.value });
          editor.editing.view.focus();
        });

        return buttonView;
      });
    });
  }

}
