/**
 * @file
 * Registers the DSFR Icon Picker to the CKEditor instance(s) and binds functionality to it.
 */

import { Plugin } from "ckeditor5/src/core";
import { ButtonView } from "ckeditor5/src/ui";
import { openDialog } from "./utils";
import iconDsfr from "../../../../img/icons/marianne-icon-fill.svg";

/**
 * @private
 */
export default class DsfrIconPickerUI extends Plugin {

  /**
   * {@inheritdoc}
   */
  static get requires() {
    return ["Widget"];
  }

  /**
   * {@inheritdoc}
   */
  static get pluginName() {
    return "DsfrIconPickerUI";
  }

  /**
   * {@inheritdoc}
   */
  init() {
    const { editor } = this;
    const command = editor.commands.get("insertIcon");

    const options = editor.config.get("dsfrIconPicker");
    if (!options) {
      return;
    }

    // The "dsfrIconPicker" button must be registered among the UI components of the editor
    // to be displayed in the toolbar.
    editor.ui.componentFactory.add( "dsfrIconPicker", locale => {
      // The button will be an instance of ButtonView.
      const buttonView = new ButtonView(locale);

      buttonView.set( {
        label: options.buttonLabel,
        icon: iconDsfr,
        tooltip: true,
      } );

      const dialogSettings = options.dialogSettings || {};

      const callback = () => {
        openDialog(options, ({attributes, element}) => {
            editor.execute("insertIcon", attributes, element);
          },
          dialogSettings,
        );
      };
      buttonView.bind("isOn", "isEnabled").to(command, "value", "isEnabled");
      this.listenTo(buttonView, "execute", callback);

      return buttonView;
    });
  }

}
