/**
 * @file
 * Provides several commands used by Ckeditor5 DSFR picker plugins.
 */

import { Command } from "ckeditor5/src/core";
import { createPictogram } from "./utils";

/**
 * @private
 */
export default class InsertPictogramCommand extends Command {
  execute (attributes, element) {
    const { model } = this.editor;
    const dsfrPictogramPickerEditing = this.editor.plugins.get(
      "DsfrPictogramPickerEditing",
    );

    const dataAttributeMapping = Object.fromEntries(
      Object.entries(dsfrPictogramPickerEditing.attrs).map(([key, value]) => [
        value,
        key,
      ]),
    );

    // \Drupal\dsfr4drupal_picker\Form\PictogramDialogForm returns data in keyed by
    // data-attributes used in view data. This converts data-attribute keys to
    // keys used in model.
    const modelAttributes = Object.fromEntries(
      Object.keys(dataAttributeMapping)
        .filter((attribute) => attributes[attribute])
        .map((attribute) => [
          dataAttributeMapping[attribute],
          attributes[attribute],
        ]),
    );

    model.change((writer) => {
      // Insert pictogram at the current selection position
      // in a way that will result in creating a valid model structure.
      model.insertContent(
        createPictogram(writer, modelAttributes, element),
      );
    });
  }

}
