<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Element;

use Drupal\Core\Render\Attribute\FormElement;

/**
 * Provides an icon picker form element.
 *
 * Usage example:
 *
 * @code
 * $form['icon'] = [
 *   '#type' => 'dsfr4drupal_picker_icon',
 *   '#title' => $this->t('Icon'),
 *   '#default_value' => 'fr-icon-warning-fill',
*    '#allowed_groups' => ['system'],
 *   '#has_search' => FALSE,
 *   '#keep_open' => TRUE,
 * ];
 * @endcode
 */
#[FormElement('dsfr4drupal_picker_icon')]
class IconPicker extends PickerBase {

  /**
   * {@inheritdoc}
   */
  const PICKER_ELEMENT = 'icon';

}
