<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Form;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\CloseModalDialogCommand;
use Drupal\Core\Form\FormStateInterface;
use Drupal\editor\Ajax\EditorDialogSave;

/**
 * Ckeditor dialog form to insert DSRR pictogram.
 */
class PictogramDialogForm extends DialogFormBase {

  /**
   * {@inheritdoc}
   */
  const PICKER_ELEMENT = 'pictogram';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dsfr4drupal_picker_pictogram_dialog_form';
  }

  /**
   * {@inheritdoc}
   */
  public function ajaxSubmitForm(array &$form, FormStateInterface $form_state) : AjaxResponse {
    $response = parent::ajaxSubmitForm($form, $form_state);

    $response->addCommand(
      new EditorDialogSave(
        [
          'element' => 'dsfrPictogram',
          'attributes' => [
            'data-pictogram' => $form_state->getValue('element'),
          ],
        ],
      )
    );
    $response->addCommand(new CloseModalDialogCommand(FALSE));

    return $response;
  }

}
