<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides the site configuration form.
 *
 * @internal
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'dsfr4drupal_picker_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['dsfr4drupal_picker.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config($this->getEditableConfigNames()[0]);

    $form['theme'] = [
      '#type' => 'radios',
      '#title' => $this->t('Widget theme'),
      '#options' => [
        'bootstrap' => $this->t('Bootstrap'),
        'dark-grey' => $this->t('Dark grey'),
        'grey' => $this->t('Grey'),
        'inverted' => $this->t('Inverted'),
      ],
      '#default_value' => $config->get('theme'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config($this->getEditableConfigNames()[0])
      ->set('theme', $form_state->getValue('theme'))
      ->save();

    drupal_flush_all_caches();

    parent::submitForm($form, $form_state);
  }

}
