<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Provides a "PickerManager" plugin manager.
 *
 * @see \Drupal\dsfr4drupal_picker\Attribute\Dsfr4DrupalPicker
 * @see \Drupal\dsfr4drupal_picker\PickerInterface
 * @see plugin_api
 */
class PickerManager extends DefaultPluginManager implements PickerManagerInterface {

  /**
   * Constructs a "PickerManager" object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cache_backend,
    ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct(
      'Plugin/Dsfr4DrupalPicker',
      $namespaces,
      $module_handler,
      'Drupal\dsfr4drupal_picker\PickerInterface',
      'Drupal\dsfr4drupal_picker\Attribute\Dsfr4DrupalPicker'
    );

    $this->alterInfo('dsfr4drupal_picker_info');
    $this->setCacheBackend($cache_backend, 'dsfr4drupal_picker_info_plugins');
  }

}
