<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Plugin\CKEditor5Plugin;

use Drupal\Core\Url;
use Drupal\dsfr4drupal_picker\PluginForm\ConfigureIconForm;
use Drupal\editor\EditorInterface;

/**
 * CKEditor 5 DSFR Icon plugin.
 *
 * @internal
 *   Plugin classes are internal.
 */
class Icon extends PluginBase {

  /**
   * {@inheritdoc}
   */
  const PICKER_ELEMENT = 'icon';

  /**
   * {@inheritdoc}
   */
  const PLUGIN_NAME = 'dsfrIconPicker';

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    $config = parent::getDynamicPluginConfig($static_plugin_config, $editor);

    $config[static::PLUGIN_NAME]['buttonLabel'] = $this->t('DSFR icons');
    $config[static::PLUGIN_NAME]['dialogSettings']['title'] = $this->t('Insert DSFR icon');

    $config[static::PLUGIN_NAME]['dialogUrl'] = Url::fromRoute(
      'dsfr4drupal_picker.icon.dialog',
      [
        'filter_format' => $editor->getFilterFormat()->id(),
      ]
    )->toString();

    return $config;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormClass($operation) {
    return ConfigureIconForm::class;
  }
}
