<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Plugin\CKEditor5Plugin;

use Drupal\Core\Url;
use Drupal\dsfr4drupal_picker\PluginForm\ConfigurePictogramForm;
use Drupal\editor\EditorInterface;

/**
 * CKEditor 5 DSFR Pictogram plugin.
 *
 * @internal
 *   Plugin classes are internal.
 */
class Pictogram extends PluginBase {

  /**
   * {@inheritdoc}
   */
  const PICKER_ELEMENT = 'pictogram';

  /**
   * {@inheritdoc}
   */
  const PLUGIN_NAME = 'dsfrPictogramPicker';

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    $config = parent::getDynamicPluginConfig($static_plugin_config, $editor);

    $config[static::PLUGIN_NAME]['buttonLabel'] = $this->t('DSFR pictograms');
    $config[static::PLUGIN_NAME]['dialogSettings']['title'] = $this->t('Insert DSFR pictogram');

    $config[static::PLUGIN_NAME]['dialogUrl'] = Url::fromRoute(
      'dsfr4drupal_picker.pictogram.dialog',
      [
        'filter_format' => $editor->getFilterFormat()->id(),
      ]
    )->toString();

    $config[static::PLUGIN_NAME]['pictoBasePath'] = base_path() . $this->picker->getItemsPath();;

    return $config;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormClass($operation) {
    return ConfigurePictogramForm::class;
  }

}
