<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin base of a DSFR icon picker widget.
 */
abstract class PickerWidgetBase extends WidgetBase {

  /**
   * The picker element.
   */
  const PICKER_ELEMENT = '';

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings(): array {
    return [
        'has_search' => TRUE,
      ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    $elements = [];

    $elements['has_search'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Display search input'),
      '#default_value' => $this->getSetting('has_search'),
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary(): array {
    $summary = [];

    $summary[] = $this->t('Display search input: @value', [
      '@value' => $this->getSetting('has_search') ? $this->t('yes') : $this->t('no'),
    ]);

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function formElement(
    FieldItemListInterface $items,
    $delta,
    array $element,
    array &$form,
    FormStateInterface $form_state
  ): array {
    $element['value'] = $element + [
      '#type' => 'dsfr4drupal_picker_' . static::PICKER_ELEMENT,
      '#default_value' => $items[$delta]->value ?? NULL,
      '#allowed_groups' => $this->getFieldSetting('allowed_groups'),
      '#has_search' => (bool) $this->getSetting('has_search'),
    ];

    return $element;
  }

}
