/**
 * @file
 * Provides toolbar used by Ckeditor5 DSFR icon picker plugin.
 */

import { Plugin } from "ckeditor5/src/core";
import { WidgetToolbarRepository } from "ckeditor5/src/widget";
import { getClosestSelectedDsfrIconWidget } from "./utils";
import DsfrIconPickerSizeEditing from "./size/editing";
import DsfrIconPickerSizeUI from "./size/ui";

/**
 * @private
 */
export default class DsfrIconPickerToolbar extends Plugin {

  /**
   * {@inheritdoc}
   */
  static get requires() {
    return [WidgetToolbarRepository, DsfrIconPickerSizeEditing, DsfrIconPickerSizeUI];
  }

  /**
   * {@inheritdoc}
   */
  static get pluginName() {
    return "DsfrIconPickerToolbar";
  }

  /**
   * {@inheritdoc}
   */
  afterInit() {
    const { editor } = this;
    const dsfrIconPickerSizeEditing = editor.plugins.get(DsfrIconPickerSizeEditing);
    const widgetToolbarRepository = editor.plugins.get(WidgetToolbarRepository);

    const items = [];
    dsfrIconPickerSizeEditing.options.forEach((option) => {
      items.push(`dsfrIconPickerSize__${option.value}`);
    });

    widgetToolbarRepository.register("dsfrIcon", {
      ariaLabel: Drupal.t("DSFR icon toolbar"),
      items: items,
      // Get the selected icon.
      getRelatedElement: (selection) =>
        getClosestSelectedDsfrIconWidget(selection),
    });
  }

}
