/**
 * @file
 * Registers the DSFR Pictogram Picker to the CKEditor instance(s) and binds functionality to it.
 */

import { Plugin } from "ckeditor5/src/core";
import { ButtonView } from "ckeditor5/src/ui";
import { openDialog } from "./utils";
import iconDsfr from "../../../../img/icons/marianne-picto.svg";

/**
 * @private
 */
export default class DsfrPictogramPickerUI extends Plugin {

  /**
   * {@inheritdoc}
   */
  static get requires() {
    return ["Widget"];
  }

  /**
   * {@inheritdoc}
   */
  static get pluginName() {
    return "DsfrPictogramPickerUI";
  }

  /**
   * {@inheritdoc}
   */
  init() {
    const { editor } = this;
    const command = editor.commands.get("insertPictogram");

    const options = editor.config.get("dsfrPictogramPicker");
    if (!options) {
      return;
    }

    // The "dsfrPictogramPicker" button must be registered among the UI components of the editor
    // to be displayed in the toolbar.
    editor.ui.componentFactory.add( "dsfrPictogramPicker", locale => {
      // The button will be an instance of ButtonView.
      const buttonView = new ButtonView(locale);

      buttonView.set( {
        label: options.buttonLabel,
        icon: iconDsfr,
        tooltip: true,
      } );

      const dialogSettings = options.dialogSettings || {};

      const callback = () => {
        openDialog(options, ({attributes, element}) => {
            editor.execute("insertPictogram", attributes, element);
          },
          dialogSettings,
        );
      };
      buttonView.bind("isOn", "isEnabled").to(command, "value", "isEnabled");
      this.listenTo(buttonView, "execute", callback);

      return buttonView;
    });
  }

}
