<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Plugin\Field\FieldFormatter;

use Drupal\Component\Utility\Html;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\dsfr4drupal_picker\Plugin\Dsfr4DrupalPicker\PictogramPickerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Plugin implementation of the 'dsfr4drupal_picker_pictogram' formatter.
 */
#[FieldFormatter(
  id: 'dsfr4drupal_picker_pictogram',
  label: new TranslatableMarkup('DSFR for Drupal - Pictogram Picker'),
  field_types: [
    'dsfr4drupal_picker_pictogram',
  ],
)]
class PictogramPickerFormatter extends FormatterBase {

  /**
   * The DSFR for Drupal pictogram picker plugin instance.
   *
   * @var \Drupal\dsfr4drupal_picker\Plugin\Dsfr4DrupalPicker\PictogramPickerInterface
   */
  protected PictogramPickerInterface $picker;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->picker = $container->get('plugin.manager.dsfr4drupal_picker')->createInstance('pictogram');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];

    // Get flatten array of DSFR pictograms.
    $pictogramsOriginal = array_merge(
      ...array_values(
        $this->picker->getItemsOriginal()
      )
    );

    foreach ($items as $delta => $item) {
      $elements[$delta] = [
        '#type' => 'component',
        '#component' => 'dsfr4drupal_picker:pictogram',
        '#props' => [
          'pictogram' => Html::escape($item->value),
          'is_dsfr' => in_array($item->value, $pictogramsOriginal),
        ],
      ];
    }

    return $elements;
  }

}
