<?php

declare(strict_types=1);

namespace Drupal\dsfr4drupal_picker\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'dsfr4drupal_picker_pictogram' field type.
 */
#[FieldType(
  id: "dsfr4drupal_picker_pictogram",
  label: new TranslatableMarkup("DSFR for Drupal - Pictogram Picker"),
  description: new TranslatableMarkup("Pick a pictogram from the DSFR library."),
  default_widget: "dsfr4drupal_picker_pictogram",
  default_formatter: "dsfr4drupal_picker_pictogram",
)]
class PictogramPicker extends PickerBase {

  /**
   * The picker element.
   */
  const PICKER_ELEMENT = 'pictogram';

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition): array {
    $definitions = parent::propertyDefinitions($field_definition);

    $definitions['value']->setDescription(new TranslatableMarkup(
  'The value is a concatenation with a “/” (slash) of the group of the pictogram and the name of the picked pictogram file.'
    ));

    return $definitions;
  }

}
