<?php

namespace Drupal\dsfr4drupal_picker\Plugin\Filter;

use Drupal\Component\Utility\Html;
use Drupal\Core\Render\BubbleableMetadata;
use Drupal\Core\Render\RenderContext;
use Drupal\Core\Render\RendererInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\filter\Attribute\Filter;
use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a filter to embed DSFR pictograms using a custom tag.
 *
 * @internal
 */
#[Filter(
  id: "dsfr4drupal_picker_pictogram",
  title: new TranslatableMarkup("Embed a DSFR pictogram"),
  description: new TranslatableMarkup("Embeds DSFR Pictograms using a custom tag, <code>&lt;dsfr-pictogram&gt;</code>."),
  type: FilterInterface::TYPE_TRANSFORM_REVERSIBLE,
  weight: 100,
)]
class PictogramPickerFilter extends PickerFilterBase {

  /**
   * {@inheritdoc}
   */
  const TAG_NAME = 'dsfr-pictogram';

  /**
   * {@inheritdoc}
   */
  const ITEM_ATTRIBUTE = 'data-pictogram';

  /**
   * {@inheritdoc}
   */
  protected function buildItem(\DOMElement $node): array {
    return [
      '#type' => 'component',
      '#component' => 'dsfr4drupal_picker:pictogram',
      '#props' => [
        'pictogram' => Html::escape(
          $node->getAttribute(static::ITEM_ATTRIBUTE)
        ),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function tips($long = FALSE) {
    if ($long) {
      return $this->t('
      <p>You can embed DSFR pictograms:</p>
      <ul>
        <li>Choose which DSFR pictogram to embed: <code>&lt;dsfr-pictogram data-pictogram="fr-" /&gt;</code></li>
        <li>Optionally also choose a size: <code>data-size="lg"</code>, otherwise the default size is used.</li>
      </ul>');
    }
    else {
      return $this->t('You can embed DSFR pictograms (using the <code>&lt;dsfr-pictogram&gt;</code> tag).');
    }
  }

}
