/**
 * Localization for Duet Date Picker. Makes use of Drupal translations
 * where possible.
 */
(function (Drupal, once) {
  Drupal.behaviors.duetDatePickerLocale = {
    attach: function (context, settings) {
      // On page load we set the localization for duet date picker.
      const localization = {
        "buttonLabel": Drupal.t("Choose date"),
        "placeholder": Drupal.t("YYYY-MM-DD"),
        "selectedDateMessage": Drupal.t("Selected date is"),
        "prevMonthLabel": Drupal.t("Previous month"),
        "nextMonthLabel": Drupal.t("Next month"),
        "monthSelectLabel": Drupal.t("Month"),
        "yearSelectLabel": Drupal.t("Year"),
        "closeLabel": Drupal.t("Close window"),
        "calendarHeading": Drupal.t("Choose a date"),
        "dayNames": [
            Drupal.t("Sunday"),
            Drupal.t("Monday"),
            Drupal.t("Tuesday"),
            Drupal.t("Wednesday"),
            Drupal.t("Thursday"),
            Drupal.t("Friday"),
            Drupal.t("Saturday")
        ],
        "monthNames": [
            Drupal.t("January", {}, {context: "Long month name"}),
            Drupal.t("February", {}, {context: "Long month name"}),
            Drupal.t("March", {}, {context: "Long month name"}),
            Drupal.t("April", {}, {context: "Long month name"}),
            Drupal.t("May", {}, {context: "Long month name"}),
            Drupal.t("June", {}, {context: "Long month name"}),
            Drupal.t("July", {}, {context: "Long month name"}),
            Drupal.t("August", {}, {context: "Long month name"}),
            Drupal.t("September", {}, {context: "Long month name"}),
            Drupal.t("October", {}, {context: "Long month name"}),
            Drupal.t("November", {}, {context: "Long month name"}),
            Drupal.t("December", {}, {context: "Long month name"})
        ],
        "monthNamesShort": [
            Drupal.t("Jan", {}, {context: "Abbreviated month name"}),
            Drupal.t("Feb", {}, {context: "Abbreviated month name"}),
            Drupal.t("Mar", {}, {context: "Abbreviated month name"}),
            Drupal.t("Apr", {}, {context: "Abbreviated month name"}),
            Drupal.t("May", {}, {context: "Abbreviated month name"}),
            Drupal.t("Jun", {}, {context: "Abbreviated month name"}),
            Drupal.t("Jul", {}, {context: "Abbreviated month name"}),
            Drupal.t("Aug", {}, {context: "Abbreviated month name"}),
            Drupal.t("Sep", {}, {context: "Abbreviated month name"}),
            Drupal.t("Oct", {}, {context: "Abbreviated month name"}),
            Drupal.t("Nov", {}, {context: "Abbreviated month name"}),
            Drupal.t("Dec", {}, {context: "Abbreviated month name"})
        ],
        "locale": "en-GB"
      }

      once('duet-date-picker-locale', 'duet-date-picker', context).forEach(function (picker) {
        if(drupalSettings.path.currentLanguage == 'fr') {
          // Set the locale for French.
          localization.locale = 'fr-FR';
        }
        picker.localization = localization;
      });
    },
  };
})(Drupal, once);
