Dumi (Direct Upload Media Image)
A quick, user-friendly, and direct image upload widget for Drupal's Media module.

 It streamlines the experience for multi-value image fields by offering a clean, interface with features like auto-expanding rows and a "Remove All" button.Features
 
 The Dumi module is an alternative to the standard "Add media" reference field widget with a specialized interface, providing the following features:
 
 Direct Image Upload: Users can click to upload / tap to upload an image directly to the media field.
 
 Media Re-use (via ID): The widget still retains a hidden input to save the Media ID, allowing for standard Drupal functionality while presenting a simplified UI.
 
 Auto-Expanding Multi-Value Fields: For multi-value fields, only rows with existing media are shown, plus one empty row for the next upload. Empty "slot" rows are automatically hidden via CSS/JS until a file is dropped or selected, preventing large, empty field tables.
 
 "Remove All" Button: A convenient button is added to clear all images from the field in a single click.
 
 Customizable Placeholder: Supports setting a custom placeholder image within the field settings for a specific Media bundle, enhancing user guidance.
 
 Responsive Design: Styled to work well across desktop and mobile devices.
 
 Requirements
 This module requires the following Drupal core modules:
 media
 file
 
 This module is currently targeted for Drupal 11 (core_version_requirement: ^11).
 
 Installation 
 Download and Place: Place the entire dumi folder into your Drupal site's /modules/custom directory.
 
 Enable: Enable the "Direct Upload Media Image" module through the Drupal administrative interface:Navigate to Extend (/admin/modules).
 
 Search for "Direct Upload Media Image" and enable it.
 
 Alternatively, use Drush: drush en dumiConfiguration and UsageAfter enabling the module, follow these steps to use the custom widget:
 1. Configure the FieldNavigate to the content type or entity where you want to use the widget (e.g., Structure > Content types > [Your Content Type] > Manage fields).
 Add a new field or edit an existing Entity Reference field that references the Media entity type.Ensure the field is configured to reference Media bundles that support image uploads (e.g., the standard Image Media bundle).
 
 2. Set the WidgetNavigate to the Manage Form Display tab for the entity/content type (e.g., Structure > Content types > [Your Content Type] > Manage form display).
 Find your Media Entity Reference field in the list.
 Change the Widget dropdown to Direct Upload Media Image.
 Click Save.
 
 3. Widget Settings (Optional)
 If your Media bundle allows, you can configure a custom placeholder image:On the Manage Form Display page, click the gear icon (⚙) next to the "Direct Upload Media Image" widget.
 The settings form will allow you to specify a URL or path to a custom image (e.g., a specific icon or outline) to be shown inside the upload box as a guide for users.
 
 4. UsageWhen editing content that uses this field:You will see a large, dashed-border container instead of the standard media reference text field.
 To Upload: Click the container to open the file selection dialog. 
 The image will be uploaded and referenced automatically.
 
 Multi-Value: A new, empty container will automatically appear after a successful upload, ready for the next image.
 
 Remove All: Click the "Remove All" button below the field group to instantly clear all selected images.
 
 Individual Removal: Click the small "x" button that appears on the container after an image has been uploaded to remove it individually.
 
 Technical Notes
 Widget Logic (PHP): The DumiWidget.php file handles the form rendering, AJAX callback for file upload, validation, and conversion of the uploaded file into a Drupal Media entity.
  
 It uses standard Drupal services for CSRF protection, file storage, and entity creation.Frontend Logic (JavaScript): 
 The dumi.js file manages the client-side user experience, 
 including:
 Hiding empty rows to maintain a clean UI (dumi-hidden-row).
 Sending the file data to the Drupal AJAX endpoint.
 Updating the UI state (default, uploading, uploaded) and rendering the preview image/filename.
 
 Styling (CSS): 
 The dumi.css file provides the necessary visual styling for the upload containers, preview, and responsive behaviour. It uses high-specificity selectors and !important declarations where necessary to override default Drupal field table styles for the required hidden/auto-expand behaviour.