<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit_demo\Plugin\ServiceInjector;

use Drupal\dx_toolkit\Plugin\ServiceInjectorBase;

/**
 * ServiceInjector plugin for config factory handlers.
 *
 * Provides editable config objects via @config.factory::getEditable
 * for specific config names. Generates services like:
 * - service_injector.system.site.config
 * - service_injector.node.settings.config
 *
 * This is a demonstration plugin showing how to create a custom
 * ServiceInjector for a specific use case. For production use,
 * you'd want a more comprehensive list or dynamic discovery.
 *
 * @ServiceInjector(
 *   id = "config_factory",
 *   label = @Translation("Config Factory"),
 *   description = @Translation(
 *     "Provides editable config objects via factory injection."
 *   ),
 *   factoryService = "@config.factory",
 *   factoryMethod = "getEditable",
 *   serviceClass = "Drupal\Core\Config\Config",
 *   servicePrefix = "service_injector",
 *   serviceSuffix = "config",
 *   deriver = (
 *     "Drupal\dx_toolkit_demo\Plugin\ServiceInjector\Derivative\ConfigFactoryDeriver"
 *   )
 * )
 *
 * @package Drupal\dx_toolkit_demo\Plugin\ServiceInjector
 */
class ConfigFactory extends ServiceInjectorBase {}
