<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit_demo\Plugin\ServiceInjector\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\DependencyInjection\ContainerBuilder;

/**
 * Deriver for ConfigFactory ServiceInjector plugin.
 *
 * Creates derivatives for commonly used config objects.
 * This is a demonstration showing how to create a deriver that
 * generates multiple service definitions from a static list.
 *
 * For a production plugin, you might want to:
 * - Dynamically discover config objects
 * - Allow configuration of which configs to expose
 * - Support module-specific config patterns
 *
 * @package Drupal\dx_toolkit_demo\Plugin\ServiceInjector\Derivative
 */
class ConfigFactoryDeriver extends DeriverBase
{

  /**
   * @inheritDoc
   */
  public function getDerivativeDefinitions(
    $base_definition,
    ?ContainerBuilder $container = NULL
  ): array {
    $config_names = [
      'system.site' => 'System Site Config',
      'system.performance' => 'System Performance Config',
      'node.settings' => 'Node Settings Config',
      'user.settings' => 'User Settings Config',
    ];

    return $this->derivatives = array_map(
      fn ($config_name, $label) => [
        ...$base_definition,
        'label' => $label,
        'description' => "Editable config for {$config_name}.",
        'factoryArguments' => [$config_name],
        'configName' => $config_name,
      ],
      array_keys($config_names),
      array_values($config_names)
    );
  }

}
