<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit_demo\Plugin\ServiceInjector;

use Drupal\dx_toolkit\Plugin\ServiceInjectorBase;

/**
 * ServiceInjector plugin for view storage.
 *
 * Provides view storage handler via @entity_type.manager::getStorage.
 * Generates service: service_injector.view.storage
 *
 * This demonstrates creating a custom ServiceInjector plugin for
 * a specific entity type without needing a deriver.
 *
 * @ServiceInjector(
 *   id = "view_storage",
 *   label = @Translation("View Storage"),
 *   description = @Translation("Provides view storage handler."),
 *   factoryService = "@entity_type.manager",
 *   factoryMethod = "getStorage",
 *   factoryArguments = ["view"],
 *   serviceClass = "Drupal\Core\Entity\EntityStorageInterface",
 *   servicePrefix = "service_injector",
 *   serviceSuffix = "storage"
 * )
 *
 * @package Drupal\dx_toolkit_demo\Plugin\ServiceInjector
 */
class ViewStorage extends ServiceInjectorBase {}
