<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Class AnnotationBase
 *  Defines a base class to use for uniformly interacting with all plugin
 *  annotations.
 *
 * @package Drupal\dx_toolkit
 */
abstract class PluginBase extends Plugin
{

  /**
   * The unique identifier for this plugin type.
   *
   * @var string
   */
  public string $id;

  /**
   * The label for this plugin type.
   *
   * @var string
   */
  public string $label;

  /**
   * A description for this plugin type.
   *
   * @var string
   */
  public string $description = '';

}
