<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

/**
 * Class Environment
 *  Extends the core Environment class to provide additional environment-related
 *  functionality.
 *
 * @package Drupal\dx_toolkit
 */
class Environment extends \Drupal\Component\Utility\Environment
{

  // TODO: Remove method if/when this issue is resolved in core.
  // @see https://www.drupal.org/project/drupal/issues/2904700
  /**
   * Detects if the current script is running in a command-line environment.
   *
   * @return bool
   *   TRUE if the current script is running in a command-line environment,
   *   FALSE otherwise.
   */
  public static function isCli(): bool {
    return defined('STDIN')
      || in_array(PHP_SAPI, ['cli', 'cli-server', 'phpdbg'], TRUE);
  }

}
